<?php 
function TWO_DEC($data) { //display
	$data = str_replace(',','',$data);	
	$data = number_format($data,2);
	$data = str_replace(',','',$data);	
	return $data;
}





function UND_DEC($data) { //display UNDEFINE DECIMAL //we need this when inserting into the database
	$data = str_replace(',','',$data);	
    //check if there is dot
    if (strpos($data, '.') !== false) {
        $nfc = substr($data, strrpos($data, '.') +1); //get numbers after a dot
        $nfc_len = strlen($nfc); //count the numbers
        $data = number_format($data,$nfc_len); //make the count as the decimal place  
    }else{
        $data = number_format($data);
    }
	$data = str_replace(',','',$data);
	return $data;
}

function num_format($data) { //display UNDEFINE DECIMAL
	$data = str_replace(',','',$data);	
    //check if there is dot
    if (strpos($data, '.') !== false) {
        $nfc = substr($data, strrpos($data, '.') +1); //get numbers after a dot
        $nfc_len = strlen($nfc); //count the numbers
        $data = number_format($data,$nfc_len); //make the count as the decimal place  
    }else{
        $data = number_format($data,2);
    }
	//$data = str_replace(',','',$data); //we need the comma this time
	if (strpos($data, '.00') !== false && $nfc_len =='2') {
		$data = str_replace('.00','',$data);
	}
	return $data;
}


function TWO_DEC_CRYPTO($data,$currency) { //display
	$data = str_replace(',','',$data);	
	if($currency=="NGN" || $currency=="USD" || $currency=="GHS"){ 
	$data = number_format($data,2);
	}else{
		if (strpos($data, 'E') !== false) { //if it has exponential.
			$data = number_format($data,8);
		}else{
			
			$nfc = substr($data, strrpos($data, '.') +1); //get numbers after a dot
			$nfc_len = strlen($nfc); //count the numbers
			if($nfc_len>8){
				$data = number_format($data,8); //make the count as the decimal place  
			}else{
				$data = number_format($data,$nfc_len); //make the count as the decimal place  
			}
		}
	}
	$data = str_replace(',','',$data);	
	return $data;
}

function amount_w_c($data,$currency) { //display
	$data = str_replace(',','',$data);	
	if($currency=="NGN" || $currency=="USD" || $currency=="GHS"){ 
	$data = number_format($data,2);
	}else{
		//do not know for now how many decimal is preferred.
	}
	
	$data = str_replace(',','',$data);

	if($currency=="NGN"){ 
		return "&#x20a6;".num_format($data)."";
	}elseif($currency=="USD"){ 
		return "&#36;".num_format($data)."";
	}elseif($currency=="GHS"){ 
		return "GHS ".num_format($data)."";
	}else{
		return "".num_format($data)." $currency";
	}
}



function amount_w_c_sm($data,$currency) { //display
	$data = str_replace(',','',$data);	
	if($currency=="NGN" || $currency=="USD" || $currency=="GHS"){ 
	$data = number_format($data,2);
	}else{
		//do not know for now how many decimal is preferred.
	}
	
	$data = str_replace(',','',$data);

	if($currency=="NGN"){ 
		return "N".num_format($data)."";
	}elseif($currency=="USD"){ 
		return "$".num_format($data)."";
	}elseif($currency=="GHS"){ 
		return "GHS ".num_format($data)."";
	}else{
		return "".num_format($data)." $currency";
	}
}



function check_email ($word,$label,$attr){ //Use only letters, numbers, dots and hyphen.
	$word = filter_var($word, FILTER_SANITIZE_EMAIL); //remove all illegal characters from email
	if(!filter_var($word, FILTER_SANITIZE_EMAIL)===false || empty($word)){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    }else{ die("<div class='alert alert-danger'> Invalid $label. Try again.</div> <script> $('[name=$attr]').css({'border-color': 'red', 'border-width':'1px', 'border-style':'solid'});</script>");  }
	$email_pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';
	if(preg_match($email_pattern, $word) === 1) {  
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    }else{ die("<div class='alert alert-danger'> Invalid $label. Try again.</div> <script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>");  }
	return;
}

function check_length ($word,$min,$max,$label,$attr){ //Use only letters, numbers, dots and hyphen.
	if(strlen($word)>=$min && strlen($word)<=$max){ 
        echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    }else{
		die("<div class='alert alert-danger'> Invalid $label length. Minimum $min & Maximum $max Characters.. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}

function no_space ($word,$label,$attr){ //for username 
	if (preg_match("/^[A-Za-z0-9-.]+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, dots and hyphen. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}

//without apostrophe
function use_lndhs ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9-. ]+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, spaces, dots and hyphen. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}
//with apostrophe
function use_lndhsa ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9\\-\\. \']+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, spaces, dots, apostrophes and hyphen. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}

//without apostrophe
function use_lndhsc ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9-., ]+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, dots, spaces, comma and hyphens. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}

//with apostrophe
function use_lndhsca ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9\\-\\., \']+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, spaces, dots, comma, apostrophes and hyphen. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


//with ?@#&*
function use_lndhscaqahas ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9\\-\\.,?@#&*! \']+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only [Aa-Za 0-9,.,'-?@#&*!]. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}

//with ?@#&*;
function use_lndhscaqahass ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9\\-\\.,;?@#&*! \']+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only [Aa-Za 0-9,.,;'-?@#&*!]. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


//with apostrophe
function check_country ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
    $word = RMC($word);
    $sql4="SELECT count(*) as sum from j_countries WHERE j_country='".$word."'"; //check 
    $result4 = runSQL($sql4);
    $data4 = mysqli_fetch_array($result4);
    $sum4 = $data4['sum'];
	//if (preg_match("/^[A-Za-z0-9\\-\\., \/\(\)']+$/", $word)) {
	if ($sum4 > 0) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		//die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, spaces, dots, apostrophes and hyphen. Try again.</div> <script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
		die("<div class='alert alert-danger'> Invalid $label. Try again.</div> <script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_address ($word,$label,$attr){ 
    $word = str_replace('\\','',$word);
	if (preg_match("/^[A-Za-z0-9 .,;-\'\]+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters, numbers, spaces, dots, apostrophe and hyphen. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_dob ($word,$label,$attr){ 
	if(preg_match("/^[0-9-]+$/", $word)){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    // Use only numbers and hyphens
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only numbers and hyphens. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_tel ($word,$label,$attr){ 
    if(strpos($word,'+')!==false){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. $label must begin with a plus (+) sign. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
	if(preg_match("/^[0-9+]+$/", $word)){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    // Use only numbers and hyphens
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use plus (+) sign and numbers. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_mobile ($phone,$country,$label,$attr){ 
    $sql4="SELECT j_phonecode from j_countries WHERE j_country='".$country."'"; //check 
    $result4 = runSQL($sql4);
    $data4 = mysqli_fetch_array($result4);
    $phonecode = $data4['j_phonecode'];
    $start_with = "+$phonecode";
    $start_with_count = strlen($start_with);
    $start_with_user = substr($phone,0,$start_with_count);
    //die("$start_with - $start_with_user");
    if(strpos($phone,'+')!==false){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. $label must begin with a plus (+) sign. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
    
    if($start_with==$start_with_user){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. $label must begin with  <b>$start_with</b> not <b>$start_with_user</b>. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
    
	if(preg_match("/^[0-9+]+$/", $phone)){
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    // Use only numbers and plus
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use plus (+) sign and numbers. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_amount ($word,$label,$attr){ 
	if (preg_match("/^[0-9.,]+$/", $word) && $word > 0) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    // contains only numbers, dots, comma
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Must be greater than zero. Use only numbers, dot and comma. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function check_ln($word,$label,$attr){ //for letters and numbers 
	if (preg_match("/^[A-Za-z0-9]+$/", $word)) {
    echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";
    } else {
		die("<div class='alert alert-danger'> Invalid $label. Use only letters and numbers. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
 	}
}


function not_in_use_words($word,$label,$attr){ 
    
    //dont let user choose a folder name
    $directories = glob('../' . '/*' , GLOB_ONLYDIR);
    foreach ($directories as $folder){
        $new_folder_1 = str_replace('..//','',$folder); 
        $new_folder_2 = strtolower($new_folder_1);
        $folders = '';
        $folders .= "".$new_folder_2.",";
    }
    $array = explode(',', $folders);
    $word = strtolower($word);
    $banned_words = array('admin','admins','fuck','user','users'); 
        
    if(in_array($word,$array) || in_array($word,$banned_words) ){
        die("<div class='alert alert-danger'> $label cannot be used. Try again.</div>
		<script> $('[name=$attr]').css({'border-color': 'brown', 'border-width':'1px', 'border-style':'solid'});</script>"); 
    }else{
        echo "<script> $('[name=$attr]').css({'border-color': '#efefef', 'border-width':'1px', 'border-style':'solid'});</script>";  
    }
}


function get_country_info($country){ 
    $sql4="SELECT * from j_countries WHERE j_country='".$country."'"; //check 
    $result4 = runSQL($sql4);
    $data4 = mysqli_fetch_array($result4);
    $country = $data4['j_country'];
    $sort_name = $data4['j_sortname'];
    $phone_code = $data4['j_phonecode'];
	return array($country,$sort_name,$phone_code);
}




function level_info($level_id,$user_id) { 
	global $company;
	global $CurrentDate;
	global $dir;
	global $acr;
	global $currency_in_use;
	global $c_def;
	global $rate_w;
	
	if($level_id=="1"){ 
		$sign_up_fee = 10;
		//$amount_to_earn = 15;
		$amount_to_earn = 9;
		$title = "LEVEL $level_id - BASIC (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$desc = "At this level, you'll need to refer two people and the two people will also refer their two people respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	if($level_id=="2"){ 
		$sign_up_fee = 20;
		$amount_to_earn = 30;
		$title = "LEVEL $level_id - PACESETTER (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		//$desc = "At this level; the two people you referred and their two each must have completed the first level respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	
	if($level_id=="3"){ 
		$sign_up_fee = 40;
		$amount_to_earn = 60;
		$title = "LEVEL $level_id - LIBERTY (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		//$desc = "At this level; the two people you referred and their two each must have completed the first level respectively and the downlines of those that just completed their first level must also complete their first level respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		//$desc = "At this level; all the people in your previous level must have completed their first level respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="4"){ 
		$sign_up_fee = 80;
		$amount_to_earn = 120;
		$title = "LEVEL $level_id - DYNAMIC (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="5"){ 
		$sign_up_fee = 160;
		$amount_to_earn = 240;
		$title = "LEVEL $level_id - GOLDEN (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="6"){ 
		$sign_up_fee = 320;
		$amount_to_earn = 480;
		$title = "LEVEL $level_id - DIAMOND (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	
	if($level_id=="7"){ 
		$sign_up_fee = 640;
		$amount_to_earn = 960;
		$title = "LEVEL $level_id - ACHIEVER (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="8"){ 
		$sign_up_fee = 1280;
		$amount_to_earn = 1920;
		$title = "LEVEL $level_id - COLOSSUS (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="9"){ 
		$sign_up_fee = 2560;
		$amount_to_earn = 3840;
		$title = "LEVEL $level_id - LEGEND (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num1 = 1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$level_id-$num1." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	
	if($level_id=="10"){ 
		$sign_up_fee = 5120;
		$amount_to_earn = 12640;
		$title = "LEVEL $level_id - ULTIMATE (".amount_w_c($sign_up_fee,$currency_in_use).")";
		//$rate_in_ngn  = TWO_DEC(usd_ngn($currency_in_use,$c_def)*$amount_to_earn);
		$rate_in_ngn  = TWO_DEC($rate_w*$amount_to_earn);
		$num = $level_id-1; $desc = "At this level; the 6 people in your first level must have completed their LEVEL ".$num." respectively to earn you <b>".amount_w_c($amount_to_earn,$currency_in_use)." (".amount_w_c($rate_in_ngn,$c_def).")</b>";
		$level_info = array($title,$amount_to_earn,$desc,$sign_up_fee);
	} 
	
	return $level_info;
}
?>